import os
import pathlib
import wandb
import torch
import os
import sys
import numpy as np
sys.path.insert(0, os.getcwd())
import tools.utils as utils
from vis.img_plt import plot_mix_img, save_ori_img
from datatool.datatool import get_dl_vl
from tools.args import get_general_args


args = get_general_args()
legend = utils.get_legend()
output_path = os.path.join(args.output_dir, args.proj_name, args.exp)
pathlib.Path(output_path).mkdir(parents=True, exist_ok=True)
wandb_path= os.path.join(args.wandb_dir, args.proj_name, args.exp)
pathlib.Path(wandb_path).mkdir(parents=True, exist_ok=True)
wandb.init(project="inex_mix", name=legend, tags=args.tags,
            dir=wandb_path, entity=args.wandb_entity)
wandb.config.update(args, allow_val_change=True)
vl_dl = get_dl_vl(args)
n_cls = args.num_labels

n_pts = 19

flst = list()

with open(os.path.join(output_path, 'flst.txt'), 'r') as fp:
    for line in fp:
        x = line[:-1]
        flst.append(x)

# display list

n = len(flst)
arn = np.arange(n)
arn = arn.reshape(-1, n_pts)
l = len(arn)

sr = np.random.rand(n_pts).argsort()
sc = np.random.rand(l).argsort()
sa = (arn[:, sr])[sc].astype(int)


def get_fnames(flst, indexes):
    return [flst[i] for i in indexes]

sflst = [get_fnames(flst, sa[:, i]) for i in range(n_pts)]

import pickle
with open(os.path.join(output_path, 'sflst.pck'), 'wb') as f:
    pickle.dump(sflst, f)


